/*global define */
/*jslint white: true */

/*
	Image:

	This object provides the implementation for images (png or jpeg).
*/

define([    "src/build/Node",   "src/utils"],
function(   Node,               utils) {
	'use strict';

	var Node_clone = Node.prototype.clone;

	function Image(image_uri, inProjectRelative, inName) {
		this.Node("Image", inName);
		this.pImage = { image_name : image_uri,
						project_relative : inProjectRelative || false};
	}

	utils.mixin(Image, Node, {
		getImageURI : function () {
			return this.pImage.image_name;
		},

		isImageURIProjectRelative : function () {
			return this.pImage.project_relative;
		},

		clone : function (clone_children, other) {
			var result = other;

			if (result) {
				// init
				Image.call(result);
			} else {
				// alloc and init
				result = new Image();
			}

			// clone node state
			Node_clone.call(this, clone_children, result);

			// deep copy image state
			utils.clone(true, result.pImage, this.pImage);

			return result;
		}
	});

	return Image;
});
